require 'rubygems'
require 'rspec'
require 'watir-webdriver'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/varUtility/landing'
require_relative '../../helper/modal'
require_relative '../../pages/base/base'
require_relative '../../pages/base/login'
require_relative '../../common/common'
require_relative '../../pages/varUtility/manage_settings'
require_relative '../../module/DateUtility'
require_relative '../../helper/table'
require_relative '../../pages/varUtility/error_validation'
require_relative '../../pages/varUtility/manage_settings/direct_scheduling'
require_relative '../../pages/varUtility/manage_settings/custom_messages'
require_relative '../../module/database/MongoUtility'
require_relative '../../pages/vaToolSet/home'
require_relative '../../pages/landing_page'
require_relative '../../common/accessVarUtility'
require_relative '../../pages/vaToolSet/home'
require_relative '../../../../acceptance-tests/watir-ruby/pages/vaToolSet/userMenu'

require 'vaToolSet/vaToolSet_pageObject'
require_relative '../../common/accessVarUtility'


describe '[Story VARUT-1346 : Manage Settings: Custom Message Option added to Manage Settings panel selection]
          [Story VARUT-1347 : Manage Settings: Edit Custom Messages (Message 1 - Date/Time)]
          [Story VARUT-1348 : Custom Messages: Restore Default for Don’t see a date or time that works for you?]
          [Story VARUT-1784 :Custom Messages: Update labeling to "Custom Text"]
          [Story VARUT-1850: Remove Type of Care custom text option]' do

  include DriverUtility
  include DateUtility
  include MongoUtility



  before(:all) do
    initializeConfigurations(BASE_URL)
    @db = connectToVarMongoDB("var-utility")
    @landing = Landing.new(@driver)
    @login = Login.new(@driver)
    @common = Common.new(@driver)
    @base = Base.new(@driver)
    @direct_scheduling = Direct_Scheduling.new(@driver)
    @manage_setting = Manage_Settings.new(@driver)
    @custom_messages = Custom_Messages.new(@driver)
    @table = Table.new(@driver)
    @error = Error_Validation.new(@driver)
    @modal = Modal.new(@driver)
    @home = Home.new(@driver)
    @user_menu = UserMenu.new(@driver)

    @loginUtil = AccessVarUtility.new(@driver)

    @landing_page = LandingPage.new(@driver)
    @vts_po  = VaToolSet_PageObject.new(@driver)
  end


  after(:all) do
    @driver.close
  end

  context '[AC#VARUT-1401|TC#1385 Validate Custom Message Option is added to Manage Settings panel selection]
           [AC#VARUT-1804|TC#VARUT-1834 Custom Messages: Update labeling to "Custom Text"]' do
    it "Remove Mongo" do
      removeCollection("custom-messages", @db)
    end

    it "Login" do
      @loginUtil.access_var_utility(UserAccess7)
      @landing.rightFooter_element.when_visible(TIME_OUT_LIMIT)
      Watir::Wait.until {@landing.rightFooter == "Logged in as PROVIDER, SEVEN"}
      expect(@landing.rightFooter).to eq("Logged in as PROVIDER, SEVEN")

      @landing_page.facility_location_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.facility_location_element.select_value('BOSTON HCS VAMC')
      @landing_page.view_settings_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.view_settings
      @common.waitWhileSpinnerPresent
    end


    it "Check Page Header" do
      @landing.home_btn_element.when_visible(TIME_OUT_LIMIT)
      @vts_po.landing.primary_header_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@vts_po.landing.primary_header).to eq("Welcome")

      @manage_setting.clickOption("Custom Text")
      expect(@landing.primary_header).to eq("Custom Text")

      @custom_messages.custom_messages_heading_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@custom_messages.custom_messages_heading).to eq("BOSTON HCS VAMC Custom Text")
      @custom_messages.instructional_text_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@custom_messages.instructional_text).to eq("Customize the text below to provide information that is specific to this location and its clinics.")
      @custom_messages.section_label_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@custom_messages.section_label).to eq("New Appointment/Request")
    end
  end

  context '[AC#VARUT-1438|TC#1439 Validate Edit Custom Messages (Message 1 - Date/Time)]
           [AC#VARUT-1863|TC#1864 Remove Type of Care custom text option]
           [AC#VARUT-1472|TC#1473 Validate Custom Messages: Restore Default for Don’t see a date or time that works for you?]' do

    it 'Error Validation' do
      @custom_messages.displayText =""
      @custom_messages.bottomSave
      @error.errorSummary_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@error.errorSummary_element.exists?).to eq(true)
      expect(@error.error_messages).to include("Message 1 Display Text field is required.")
    end


    it 'Validate Confirmation modal on save' do
      @custom_messages.displayText= "Custom Message Should be Entered Here."
      expect(@custom_messages.displayText).to eq("Custom Message Should be Entered Here.")
      expect(@custom_messages.displayText2?).to eq(false)
      #@custom_messages.displayText2 = "The second Custom Message can be entered here."
      #expect(@custom_messages.displayText2).to eq("The second Custom Message can be entered here.")
      @custom_messages.displayText3 = "The third Custom Message can be entered here"
      expect(@custom_messages.displayText3).to eq("The third Custom Message can be entered here")
      @custom_messages.bottomSave
      @modal.modalTitle_element.when_visible(TIME_OUT_LIMIT)
      @modal.ok
    end

    it 'Logout and Log back in as different user for same location to verify the last saved data is displayed' do
       @common.logoutAndLogbackWithADifferentUser("ACCESS50", "VERIFY50!", "BOSTON HCS VAMC")
      # @common.waitWhileSpinnerPresent()
      # @landing.footerUserInfo_element.when_visible(TIME_OUT_LIMIT)
      # Watir::Wait.until {@landing.footerUserInfo == "Logged in as PROVIDER, FIFTY"}
      # expect(@landing.footerUserInfo).to eq("Logged in as PROVIDER, FIFTY")
      # @landing.home_btn_element.when_visible(TIME_OUT_LIMIT)

      #@user_menu.userMenu_element.when_visible(TIME_OUT_LIMIT)
      #@user_menu.logOut_element.when_present

      # @vts_po.loginLogout.logout
      #@vts_po.loginLogout.login(UserAccess50)

      @home.varUtilOpen_element.wait_until_present(TIME_OUT_LIMIT)
      @home.varUtilOpen
      @landing_page.facility_location_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.facility_location_element.select_value('BOSTON HCS VAMC')
      @landing_page.view_settings_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.view_settings
       @landing_page.change_location_element.wait_until_present(TIME_OUT_LIMIT)
       expect(@landing_page.options_list_element[2].text).to eq("Custom Text")
       @manage_setting.clickOption('Custom Text')
      expect(@landing.primary_header).to eq("Custom Text")
      @common.waitWhileSpinnerPresent
      expect(@custom_messages.displayText).to eq("Custom Message Should be Entered Here.")
     # expect(@custom_messages.displayText2).to eq("The second Custom Message can be entered here.")
      expect(@custom_messages.displayText3).to eq("The third Custom Message can be entered here")
    end



    it 'Validate Confirmation Modal When Navigating without Save,' do
      @custom_messages.displayText = "Change text to Open Confirmation Modal."
      button_element = @driver.button( :id=>'home-btn')
      @driver.execute_script("$(arguments[0]).click();",button_element)
      @common.waitWhileSpinnerPresent
      @modal.modalTitle_element.when_visible(TIME_OUT_LIMIT)
      expect(@modal.modalTitle).to eq("Popup modal\nConfirmation")
      expect(@modal.content).to eq("You have not saved your changes. If you wish to continue without saving select CONTINUE, otherwise select RETURN to return to the entry screen.")
      @modal.buttons_elements[0].click
      @common.waitWhileSpinnerPresent
      @modal.modalTitle_element.wait_while_present(TIME_OUT_LIMIT)

    end



    it 'Validate Restore Default button' do
      @landing_page.change_location_element.wait_until_present(TIME_OUT_LIMIT)
      #@manage_setting.clickOption("Custom Text")
      @common.waitWhileSpinnerPresent
      Watir::Wait.until{@custom_messages.displayText.present?}
      expect(@custom_messages.displayText).to eq("Change text to Open Confirmation Modal.")
      #expect(@custom_messages.displayText2).to eq("The second Custom Message can be entered here.")
      expect(@custom_messages.displayText3).to eq("The third Custom Message can be entered here")
      @custom_messages.restoreDefaultMessage1_element.wait_until_present(TIME_OUT_LIMIT)
      @custom_messages.restoreDefaultMessage1
      @common.waitWhileSpinnerPresent
      @custom_messages.restoreDefaultMessage2_element.wait_until_present(TIME_OUT_LIMIT)
      @custom_messages.restoreDefaultMessage2
      @common.waitWhileSpinnerPresent
      #@custom_messages.restoreDefaultMessage3
      @common.waitWhileSpinnerPresent()
      expect(@custom_messages.displayText).to eq("Scheduling Clerks may be able to find additional dates and times for you. To request assistance, change the scheduling method you selected to \"Request help scheduling\" and submit the request details. A clerk will contact you to provide assistance.")
      #expect(@custom_messages.displayText2).to eq("If you don't see a Type of Care that matches your needs, contact your facility for assistance.")
      expect(@custom_messages.displayText3).to eq("If you don't see the clinic that matches your needs, contact your facility for assistance.")
      @custom_messages.bottomSave
    end

  end

end
